# 混合种植
你可能已经注意到，有时植物种在一起时的产量会更高。
草、灌木、树和胡萝卜在有合适的伴生植物时产量更高。每个植物的伴生偏好都不同，无法预测。还好，无人机下方植物的伴生偏好可以使用 `get_companion()` 来测量。结果会返回一个元组，其中第一个元素是植物想要的伴生植物类型，第二个元素则是它想要伴生植物种下的位置。

`plant_type, (x, y) = get_companion()`

例如，如果你在种植一棵灌木后调用 `get_companion()`，就会返回类似 `(Entities.Carrot, (3, 5))` 的结果，表示这棵灌木希望 `(3,5)` 的位置长有胡萝卜。所以如果你在 `(3,5)` 处种植胡萝卜后收获这棵灌木，它会产出更多的木材。胡萝卜的生长阶段无关紧要。

植物的伴生偏好可以是 `Entities.Grass`、`Entities.Bush`、`Entities.Tree` 或 `Entities.Carrot`。每个植物都会随机选择，但总是会选择与自身不同的植物。位置也可以是植物周围 3 步内除其本身所在之外的任何位置。

如果无人机下方没有具有伴生偏好的植物，`get_companion()` 将返回 `None`。

在混合种植解锁之前，产量乘数是 `5`，之后每次升级倍率都会增加。